# Brightening up Biology: Advances in Luciferase Systems for in Vivo Imaging

Shirley Liu, Yichi Su, Michael Z. Lin, and John A. Ronald\*

Cite This: ACS Chem. Biol. 2021, 16, 2707-2718

![](images/1d96b606673028067651267eef92fa3b6e7dabc0bd7f3c7e4aa3ba8db1aef524.jpg)![](images/efb469f33d96ac51106878bba99b60a7bdf0ab463369b7faf659fc5f1c416df9.jpg)![](images/e6aa0fb2e537bfdec38a95cc861cb96dabebba44f3810ff0299e4ad6f554128e.jpg)  
ABSTRACT: Bioluminescence imaging (BLI) using luciferase reporters is an indispensable method for the noninvasive visualizationofcellpopulationsandbochemicalevents inlvinganimals.BLI is widelyperformed with preclinicalrodent models to understand disease processesadevaluate potentialcellorgene-based therapies.However, iviv Lremainsconstrainedbylow photon production andtssueatenuation,limiting the sensitivityofreportingfromsmallnumbers of cell indeep lcatios and hinderingitsaplicationtolarger animal models.This Reviewhighlightsrecent advances inthedevelopmentofluciferase systems that improve the sensitivity of in vivo BLI and discusses the expanding array of biological applications.

# INTRODUCTION

Bioluminescence imaging (BLI） with luciferase reporters is a highly valuable technique for tracking genetically labeled cell populations and monitoring molecular processes in vivo.In its simplest form, BLI detects the presence of labeled cels at a particular location over time，which can reveal changes in cellular proliferation or survival throughout development, disease,or therapy.1 In a more specific scheme,the expression of luciferase reporters can be made responsive to biochemical signals,allowing BLI to track these signals over time.² A major advantage of BLI is that it can be performed longitudinally and noninvasively. Other benefts of BLI include the lack of an intrinsic bioluminescence signal in animals allowing for high sensitivity and specificity，its relative simplicity and affordability,and the ability to perform simultaneous whole-body imaging of model animals such as mice.3-5

To perform BLI, cells are genetically engineered to express a luciferase enzyme that reacts with an exogenously delivered substrate to produce light, which is then detected by a camera6 (Figure lA).The most thoroughly studied luciferases are those isolated from insects,with the Photinus pyralis firefly luciferase (FLuc）being the most widely used. In insect luciferases, oxidation of the substrate D-luciferin in the presence of oxygen, ATP,and $\mathrm { M g } ^ { 2 + }$ produces yellow light with an emission peak at $5 7 8 ~ \mathrm { n m }$ at $2 5 ~ ^ { \circ } C .$ Other insect luciferases that are used for BLI include those from the firefly Luciola italica and the click beetle Pyrophorus plagiophthalamus.A larger number of known luciferases，however，originate from marine organisms and produce blue light (emission peak $4 5 0 { - } 5 0 0 \ \mathrm { n m }$ ）from the oxidation of coelenterazine (CTZ） in the absence of cofactors other than oxygen. Commonly used CTZ-dependent systems include Renilla (RLuc)，Gaussia (GLuc)，and NanoLuc luciferases.9

![](images/fdef7efcb06dfc1567daab13a42e7241eaa58a707dd251335b19a2b160d0a9a3.jpg)  
Figure1Invieegegdel.(）Celrsgeicalgdtxpsti trasplatedtaebee.)c value of water, oxyhemoglobin $\left( \mathrm { H b } \mathrm { O } _ { 2 } \right)$ ,and deoxyhemoglobin (Hb) for wavelengths in the visible to near-infrared region.Adapted with permission fromKobayashetlorightmericaCeicalety

BLI detection favors superficially located cells due to absorption and scattering of light by tissue.In mammalian tissues,hemoglobin impairs transmission of wavelengths below $6 0 0 ~ \mathrm { { \ n m } }$ ，which partially or completely overlaps with the emission spectra of most natural luciferases discovered to dateTherefore,toimprove thedetectionofsparsecell populations at greater tissue depths, it would be advantageous to develop luciferases with red-shifted emission spectra (Figure 1B).Alternatively, luciferases with higher specific activity or higher levels of expression (through more efficient translation or slower degradation） would improve limits of detection for small numbers of cels but alone would not reduce depthdependent attenuation.Additionally,many current substrates possess uneven biodistribution within mice.For example, intravenously injected $^ { 1 4 } \mathrm { C - D }$ -luciferin showed early high uptake in the kidney and liver, late predominant uptake in the bladder，and limited access to the brain.11 Substrate solubility and stability are also limiting factors of CTZ and its analogs. 12

Due to these limitations，significant efforts have been invested in the development of improved BLI luciferase/ luciferin pairs for improved monitoring of cellular processes. Here，we summarize recent advances in luciferase systems aimed to improve in vivo sensitivity in mammalian model systems,and we highlight novel biological applications of the expanding BLI toolbox.

# BLI SYSTEMS ENGINEERING

With the goal of improving detection sensitivity from deep locations in mammalian subjects,multiple efforts have attempted to mutate luciferases to increase catalytic activity or to red-shift emission (Table 1). One of the earliest examples of wavelength shifting comes from the $\mathrm { S } 2 8 4 \mathrm { T }$ mutant of FLuc, PpeRS,discovered by random mutagenesis to create a ${ \sim } 5 0 ~ \mathrm { n m }$ red-shift in the emission peak.13 However, the brightness of PpeRS in vivo is not significantly increased, suggesting the mutation merely eliminates the production of green photons rather than increasing the output of red photons.A similar observation of selective loss of green emission without an increase in red emission was made with a Y257A mutation in Luciola firefly luciferase,which also produced a ${ \sim } 5 0 ~ \mathrm { n m }$ redshift.14 Efforts on RLuc engineering have been relatively more successful in emission shifting.The RLuc8 variant, consisting of eight mutations, displays a 4-fold increase in brightness, while $\mathrm { R L u c } 8 . 6 - 5 3 5$ exhibits a $5 0 ~ \mathrm { { n m } }$ peak wavelength shift to $5 3 5 ~ \mathrm { n m }$ and 2.6-fold brighter emission than RLuc8 at a tissue depth of $1 { - } 2 ~ \mathrm { \ m m }$ .16 This suggests that the increased brightness of $\mathrm { R L u c } 8 . 6 - 5 3 5$ is indeed due to an increased production of red photons,as desired.However, the emission spectrum of $\mathrm { R L u c } 8 . 6 - 5 3 5$ lies nearly completely below 600 nm，reducing the sensitivity of imaging by $\mathrm { R L u c } 8 . 6 - 5 3 5$ to lower than that of FLuc.

<html><body><table><tr><td> category</td><td> luciferase(s)</td><td> substrate(s)</td><td>emission peak</td><td> advantages</td><td> disadvantages</td><td>refs</td></tr><tr><td>frfly luciferase (FLuc)</td><td>FLuc</td><td>D-luciferin</td><td>578 nm</td><td>efective at shallow tissue imaging low background emission</td><td>poor substrate blood-brain barrier permeability ATP-dependent (as are all FLuc-based</td><td>7,8, 54</td></tr><tr><td></td><td>FLuc</td><td>aminoluciferins (e.g., CycLucl,cybLuc）up to</td><td>591 nm</td><td>superior to D-luciferin at several-fold lower dose</td><td>systems) substrate solubility may be lower than D- luciferin</td><td>22, 23, 55</td></tr><tr><td></td><td>FLuc</td><td>near-infrared (NIR) luciferins</td><td>up to</td><td>improved blood-brain barrier permeability more sustained signal longer half-life in bloodand higher affinity to FLuc</td><td></td><td>32</td></tr><tr><td></td><td>Akaluc</td><td>AkaLumine-hydrochloride (AkaLumine- 650 nm</td><td>690 nm</td><td>capable of single-cell detection in deep tissues</td><td>background hepatic signal</td><td>27,30</td></tr><tr><td></td><td>Akaluc</td><td>HCl) seMpai</td><td>675 nm</td><td>demonstrated video-rate deep-brain imaging in marmosets no background hepatic signal</td><td>potential toxicity due to acidosis lower brightness and affinity to Akaluc</td><td></td></tr><tr><td></td><td>FLuc mutants (x5, x5</td><td>infraluciferin</td><td>up to</td><td>produces distinct bioluminescent colors with various</td><td>compared to AkaLumine-HCl</td><td>31 33,56</td></tr><tr><td>click beetle luciferase</td><td>S284T) click beetle mutants (CBR2，NH2-NpLH2 CBG2）</td><td></td><td>706 nm up_to</td><td>mutants produces distinct bioluminescent colors with various</td><td></td><td>34, 57</td></tr><tr><td>Renilla luciferase (RLuc)</td><td>RLuc</td><td>CTZ</td><td>730 nm 482 nm</td><td>mutants ATP-independent (as are all CTZ-based systems)</td><td>poor tissue penetration due to blue light emission</td><td>36, 58</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td>high substrate autoluminescence rapid inactivation in serum poor tissue penetration due to blue light</td><td></td></tr><tr><td></td><td>RLuc8</td><td>ViviRen CTZ</td><td>482 nm 487 nm</td><td>reduced autoluminescence compared to CTZ 4-fold brighter in vitro and 20o-fold more resistant to</td><td>emission poor tissue penetration due to blue light</td><td>39 15</td></tr><tr><td></td><td>RLuc8.6-535</td><td>CTZ</td><td> 535 nm</td><td>inactivation in serum than RLuc 2.6-fold brighter than RLuc8 in vivo</td><td>emission</td><td>16</td></tr><tr><td>NanoLuc</td><td>NanoLuc</td><td>furimazine, hydrofurimazine (HFz), fluorofurimazine (FFz)</td><td>460 nm</td><td>small size and high structural stability</td><td>poor tissue penetration due to blue light</td><td>44, 59</td></tr><tr><td></td><td>Antares</td><td>furimazine, HFz, FFz</td><td>584 nm</td><td>9-fold brighter with FFz than furimazine 13-fold brighter than FLuc/D-luciferin at equivalent dose</td><td>emission</td><td>30,53</td></tr><tr><td></td><td>teLuc</td><td>diphenylterazine (DTZ)</td><td>502 nm</td><td>in vivo</td><td>54-foldbrighter than FLuc/D-luciferin at equivalent dosesubstrate solubility is lower than D-luciferin</td><td>45</td></tr><tr><td></td><td>Antares2</td><td></td><td>584 nm</td><td>in vivo 35-90% signal increase over teLuc/DTZ in vivo</td><td>substrate solubility is lower than D-luciferin</td><td></td></tr><tr><td></td><td>LumiLuc</td><td>DTZ 8pyDTZ</td><td>525 nm</td><td>enhanced substrate solubility compared to DTZ</td><td></td><td>45 46</td></tr><tr><td></td><td>LumiScarlet</td><td></td><td>600 nm</td><td>3-fold brighter than Akaluc/AkaLumine-HCl in vivo 3-fold brighter than LumiLuc/8pyDTZ in vivo</td><td></td><td></td></tr><tr><td>Gaussia luciferaseGLuc (GLuc)</td><td></td><td>8pyDTZ CTZ</td><td>480 nm</td><td>secreted into circulation</td><td>poor tissue penetration due to blue light emission</td><td>46 60</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td>high substrate autoluminescence rapidly decaying signal</td><td></td></tr><tr><td></td><td>GLuc variants (e.g., I90L, 8990,Monsta)</td><td>CTZ</td><td>upto</td><td>up to 7-fold brighter than native GLuc in vivo</td><td>up to only 1.7% of photons &gt;600 nm</td><td>61</td></tr></table></body></html>

![](images/9a39c5303680a3a3af5d84ebf519c049500b81800b733e8ab6dd7058d9f44cda.jpg)  
Figure2.Chemialtructuresoftielciferinsandteiraalog: (A)atieisctluciferasesbstrateiferinandtsalog.(Batie marine luciferase substrate coelenterazine and its analogs.

Taken together, these early studies suggest that mutagenesis of insect and marine luciferases alone may not be sufficient to dramatically improve in vivo performance of these BLI systems. Thus，additional strategies， such as engineering of luciferase substrates with improved emission characteristics or dramatically red-shifting emission using bioluminescence resonance energy transfer (BRET), may be necessary.

Synthetic Substrate Analogs. An orthogonal approach to modifying bioluminescence properties，and one that can overcome wavelength limitations inherent to D-luciferin or coelenterazine,is to chemically alter the substrate (Figure 2). Substrate engineering is often then accompanied by enzyme engineering to ensure maximal optimization of the system.For the firefly luciferase system，it has been discovered that emission color is primarily determined by the charge distribution on the oxyluciferin product.17 Various methods to redistribute the electronic charge，such as replacing substituent groups or extending conjugation on the luciferin, have led to the synthesis of novel luciferin analogs capable of red-shifting the emission light.18,19 Efforts have also focused on modifying luciferins to enhance the circulation time，water solubility,and membrane permeability of luciferins for deep tissue imaging.20,21

A major group of D-luciferin analogs is based on aminoluciferins. The first aminoluciferin analog was developed in 1966 by replacing the ${ { \boldsymbol { 6 } } ^ { \prime } }$ -hydroxyl group of D-luciferin with an amino group,resulting in a peak emission shift to $5 9 0 ~ \mathrm { n m }$ and a ${ \sim } 1 0$ fold increased affinity for FLuc.2² Research focused on optimizing analogs for in vivo imaging led to the development of the cyclic alkylaminoluciferin CycLuc1.When injected at a dose 2O-fold lower than D-luciferin, CycLucl can still lead to brighter signal and achieve sensitive brain imaging in FLucexpresing mice.2324Whilewild-typeFLucispromiscuous Adams et al. later engineered some FLuc mutants that exhibit 40-50-fold selectivity for aminoluciferins (including CycLuc1) over D-luciferin in mouse brains.25 Notably, when paired with aminoluciferins,the engineered FLuc variants did not exhibit increased brightness，indicating the primary cause of the selectivity is likelya loss of utilization of D-luciferin rather than increased utilization of the synthetic aminoluciferins.Recently, Wu et al.investigated a series of novel N-cycloalkylaminoluciferins called cyaLucs and reported one analog, cybLuc,with improved sensitivity in vivo.At maximum doses ( $1 0 0 ~ \mathrm { m M }$ for D-luciferin and $1 0 ~ \mathrm { m M }$ for CybLuc), CybLuc provided 7-fold brighter bioluminescence in the mouse brain, which suggests that cybLuc can efficiently traverse the blood-brain barrier and has higher accessibility to deep brain tissues.In addition, the cybLuc signal plateaued for more than $3 0 \mathrm { m i n }$ ,whereas the D-luciferin signal began to drop after only $5 \ \mathrm { m i n }$ ， suggesting cybLuc can be used in applications requiring long-time observation in vivo.

Recent efforts have succeeded in further shifting bioluminescence into the near-infrared (NIR) region. Kuchimaru et al.synthesized a novel luciferin analog，AkaLuminehydrochloride (AkaLumine-HCl),by replacing the benzothiazole structure in D-luciferin with a dimethylaniline moiety and extending the $\pi$ -conjugated system.26 When paired with native FLuc,AkaLumine-HCl emits NIR light peakingat $6 7 7 ~ \mathrm { { n m } }$ and possesses a more favorable biodistribution.Iwano et al. further refined this system by engineering FLuc through successive rounds of mutagenesis to optimize pairing with AkaLumineHCl,and their work yielded the novel luciferase Akaluc.27 Imaging with Akaluc/AkaLumine-HCl exhibited up to 1000 times brighter emissions in vivo compared to FLuc/D-luciferin and was capable of single-cell detection in deep lung tissues in mice.Additionally，improved BLI in the brain owing to effcient blood-brain-barrier penetration of AkaLumine-HCl enabled video-rate imaging of striatal neurons in marmosets,a significant milestone in in vivo BLI.Later, the superiority of Akaluc over FLuc was recaptured in the mouse brain. 28

However, it was questioned by another study when applied in the imaging fate of cell therapy outside the brain,although in this research D-luciferin was administered at a dose 6-fold higher than common usage.29 Some potential drawbacks of AkaLumine-HCl include the background hepatic signal30,31 and noticeabletoxicitytoskinandheart931likelydue tothe acidity in AkaLumine-HCl solution.A structurally similar luciferin analog, seMpai, does not produce a detectable hepatic signal when paired with Akaluc in vivo and may be more suitable for sensitive imaging of the liver,although at the cost of lower brightness compared to AkaLumine-HCl.31

In 2020, Ikeda et al. further expanded the palette of NIRemitting substrates with the development of NIR luciferins (NIRLucs).32 Using the structure of AkaLumine asa framework, they synthesized a series of novel luciferins via a ring fusion strategy and reached peak wavelengths up to 690 nm when paired with FLuc. One candidate, NIRLuc2, was tested in vivo. Although NIRLuc2 was dimmer than AkaLumine in vitro,it was comparable to AkaLumine in a subcutaneous tumor model which might be due to its improved pharmacokinetics properties (although the dose was questionably maintained at $5 ~ \mathrm { \ m M }$ and intravenous injection was adopted instead of intraperitoneal).More sustained bioluminescence was also achieved as a result of longer half-life in blood and higher affinity to FLuc.

Other NIR luciferins include the beetle luciferin analog infraluciferinwithassionakat $7 0 8 \ \mathrm { n m }$ 33 Moreover, infraluciferin produces distinct bioluminescent colors with various luciferase mutants and therefore may be useful for imaging multiple cell populations or biochemical processes within the same animal (see the Multicomponent BLI section). Similarly, the naphthyl-based luciferin $\mathrm { N H } _ { 2 } { \mathrm { - N p L H } } 2$ can be paired with the mutant click beetle red luciferase (CBR2） to produce NIR emission $\left( 7 3 0 \mathrm { n m } \right)$ ,with potential applications in multicomponent imaging.34

Investigation into novel CTZ analogs that enhance bioluminescence in animals has also been a wide field of study. However, this has been much more challenging due to the blue emission of native CTZ systems.35 It should also be noted that due to its unstable imidazopyridine structure，CTZ can undergo enzyme-independent oxidation，resulting in background autoluminescence.36 Substitution at the C-2, C-5, C-6, and C-8 positions of the imidazopyrazinone core has yielded enhancements in bioluminescence properties,with changes at the C-2 position modifying the reaction rate and the C-6/C-8 positions influencing the emission spectra.37,38 One notable CTZ analog developed by Promega Corporation， ViviRen, exhibited up to a l0-fold higher signal in vivo than CTZ when paired with RLuc, while showing reduced autoluminescence.39 Recent studies and overviews covering the progress of the chemical synthesis and structure-activity studies of CTZ analogs exist for interested readers.37,40-43

In 2012,Promega Corporation synthesized furimazine,a CTZ analog containing a furan group at the C-2 position that could pair with NanoLuc,an engineered luciferase derived from the small luciferase subunit ( $\left( 1 9 \mathrm { \ k D a } \right)$ of the deep sea shrimp Oplophorus gracilirostris.44 The NanoLuc/furimazine pair produced ${ \sim } 1 5 0$ -fold greater bioluminescence in vitro compared to RLuc/CTZ,with a slightly blue-shifted emission wavelength ( $\left( 4 6 0 \mathrm { n m } \right)$ ).Because of its brightness,small size,and high stability，NanoLuc was quickly commercialized for widespread use in cell-based assays; however,its blue emission still limited in vivo applications.Yeh et al.were successful in red-shifting its emisson by engineering it to pair with the CTZ analog diphenylterazine (DTZ)，resulting in the teLuc luciferase with an emission peak at $5 0 2 \ \mathrm { \Omega n m }$ 45 Imaging in deep tissues of mice with teLuc/DTZ generated ${ \sim } 5 4$ -fold brighter emisson than FLuc/D-luciferin at an equivalent dose. Yeh and colleagues then synthesized 8pyDTZ,an analog with 4- to 14-fold enhanced solubility.46 They then performed directed evolution of teLuc to optimize pairing with 8pyDTZ, resulting in the LumiLuc luciferase which also exhibited a shifted emission peak at $5 2 5 ~ \mathrm { { n m } }$ LumiLuc/8pyDTZ produced ${ \sim } 3$ -fold higher photon flux than Akaluc/AkaLumine-HCl from superficial implants in mice.

![](images/287494b8558aea2ccc55124fe096e98c6e9f8654594001dfb79fcf390b1ccacb.jpg)  
Figure3.BioleseesoceetrasferETbasedufetes: (A)Aciferaoactsititssbstratetruce lightwhichisthenabsorbedbyafusedfuorescentproteinandre-emitedatalongerwavelength(B）Luc-basedBRETsystemsand(C) NanoLuc-based BRET systems and their respective peak emission wavelengths.

BRET-Based Luciferase Systems. In nature, multiple marine organisms have evolved bright luciferase-fluorescent protein systems that utilize the phenomenon of BRET.In BRET，the excited luciferase-bound substrate transfers its energy to an acceptor chromophore through a nonradiative dipole-dipole coupling mechanism, of which the efficiency is dependent on the spectral overlap and intermolecular distance between the two molecules (Figure 3A)． The resulting emission light from the acceptor chromophore exhibitsa red-shifted spectrum and overall higher quantum yield. Inspired by nature,multiple engineering efforts on marine luciferases have focused on using BRET to red-shift emission and enhance bioluminescence brightness.

Most of the early examples of BRET-based reporters were based on RLuc or its enhanced variants (Figure 3B).BRET6, a TurboFP635-RLuc8.6 fusion protein, enabled direct imaging of drug-mediated protein-protein interaction in deep tissues of living mice.47eBAF-Y，consisting of enhanced yellow fluorescent protein (EYFP）and RLuc8，displayed 26-fold bioluminescence enhancement over RLuc and 3-fold over

RLuc8.48 In a more recent study, by replacing EYFP with Venus and extensively optimizing the unstructured linker, Saito et al.developed an enhanced BRET-based reporter termed Nano-Lantern with a 2.9 times brighter emission than eBAF-Y. Notably，the enhanced signal enabled video rate $\left( 3 0 \ \mathrm { ~ H z } \right)$ imaging of luciferase-expressing tumors in freely moving unshaved mice.49 In another interesting example,RLuc8 was fused with iRFP670 or iRFP720，phytochrome-based NIR fluorescent proteins that have an excitation peak at around 380 nm, to create reporters with NIR emission.50 Compared to NIR fluorescent in vivo imaging, NIR BLI provided 10-fold increased sensitivity,enabling detection of as low as $1 0 ^ { 4 }$ tail vein-injected MTLn3 tumor cells in the lungs of CFW mice. However， fluorescent proteins alone may still be beneficial when substrate delivery is an issue or in hypoxic regions for oxygen-dependent luciferases.

Ever since its development, NanoLuc has become a popular donor for engineering novel BRET-based reporters due to its superior catalytic efficiency over RLuc variants (Figure 3C). By replacing RLuc8 in Nano-Lantern with NanoLuc,a series of enhanced Nano-Lanterns (eNL) were reported.51 Specifically, fluorescent proteins mTurquoise2，mNeonGreen，Venus, $\mathrm { m K O } \kappa ,$ and tdTomato were chosen as BRET acceptors to generate cyan (CeNL, $4 7 5 ~ \mathrm { \ n m } ,$ ），green( $\scriptstyle \mathrm { \mathrm { G e N L } }$ ， $5 2 0 ~ \mathrm { n m } ,$ )， yellow (YeNL, $5 3 0 \ \mathrm { n m } ,$ ），orange(OeNL， $5 6 5 \ \mathrm { n m } ,$ ，and red (ReNL, $5 8 5 ~ \mathrm { \ n m } ,$ ）eNLs.Among them，CeNL and GeNL showed a roughly 2-fold increased total luminescence intensity compared to NanoLuc,while YeNL and OeNL were 4-or 1.8- fold brighter than their Nano-Lantern counterparts YNL and ONL.Meanwhile, in an independent study, two other chimeric fusion reporter proteins termed LumiFluors were developed using a similar design.52 The green LumiFluor, eGFP-NanoLuc (GpNLuc), displayed 45-fold more luminescence than YNL in vitro.In NOD/SCID mice, following a tail vein injection of 500 000 GpNLuc-expressing tumor cells，colonization could easily be detected in the lungs. The orange LumiFluor, LSSmOrange-NanoLuc (OgNLuc)，was even several fold brighter than GpNLuc for imaging allografts of mouse lymphoma cells in Albino C57Bl/6 mice.Given their similar signal intensity in vitro,this improvement in vivo supports the strategy of red-shifting luciferases for enhanced tissue penetration.

![](images/6742b4769c66796571504f1b5914bf812429aa198d1973a7c476749596264b0c.jpg)  
Figure4.Exaplefssitieuopoetabledyaefartesntssts:(A）hfxpeealeiforin vivo trackingofotAntaresxpessuorcellscexpressingCATcell.）Represeatieimagesogegein tumorsizeand thelocalizationof expandedCAR-Tcell.Adaptedwithpermission from Su etal.3Copyright2020 SpringerNature.

While most BRET systems exploit one copy of the fluorescent protein as the acceptor， introducing multiple copies may further enhance the BRET efficiency. On the basis of this hypothesis,two copies of CyOFP1,a bright cyanexcitable orange fluorescent protein,were fused to both the Nand C-termini of NanoLuc to create a highly sensitive bioluminescent reporter called Antares.53 When compared to the spectrally similar bioluminescent protein ONL，Antares produced 20-fold more photons across all wavelengths and 28- fold more above $6 0 0 \ \mathrm { n m }$ in vitro.

Other engineered luciferases based on NanoLuc, such as teLuc and LumiLuc mentioned above,were also exploited as donors in BRET systems. Compared to NanoLuc/furimazine, the emission of teLuc/DTZ peaking at $5 0 2 ~ \mathrm { n m }$ overlaps better with the absorbance of CyOFP1 in Antares.Thus,NanoLuc in Antares was replaced by teLuc to generate Antares2,which consistently exhibits a $5 8 4 \mathrm { n m }$ emission peak. In BALB/c mice, when luciferase-coding plasmids were hydrodynamically delivered to have luciferases expressed in the liver，and equimolar doses of luciferase substrates were administered intraperitoneally，Antares2 exhibited an approximately $3 5 -$ $9 0 \%$ signal increase over teLuc and Antares.45 For the BRET system that utilizes LumiLuc/8pyDTZ,which is further redshifted from teLuc-DTZ,a recently reported red fluorescent protein mScarlet-I was adopted instead as the BRET acceptor.46 The resulting fusion protein mScarlet-I-LumiLuc, named LumiScarlet, has an emission peak at $6 0 0 \ \mathrm { n m }$ and has

$5 1 \%$ of its emitted photons above $6 0 0 \ \mathrm { n m }$ .When applied to image luciferase-expressing HeLa cells trapped in the lungs of NU/J mice with intravenously injected substrates, LumiScarlet-8pyDTZ gave a comparable signal to that from Akaluc with a comparable amount of intravenous AkaLumine-HCl, and 3- fold brighter than that from LumiLuc/8pyDTZ.

However, the brightness of Antares or LumiScarlet with the more convenient intraperitoneal injection of furimazine or 8pyDTZ does not reach the brightness attainable by AkaLuc with intraperitoneal AkaLumine delivery.30,45Two NanoLuc substrates，hydrofurimazine $\left( \mathrm { H F z } \right)$ and fluorofurimazine $\left( \mathrm { F F z } \right)$ ，with a higher aqueous solubility that can be injected into higher total amounts were recently reported.30 When coupled with Antares， these novel substrates enabled comparable or even brighter bioluminescence in vivo compared to AkaLuc/AkaLumine at limiting doses for each substrate.

# BLI SYSTEMS APPLICATION—MULTICOMPONENT BLI

In many biological studies，the need to observe different cellular events within the same animal requires the cells of interest to be tagged with multiple luciferases.Applications include investigations into the endogenous expression patterns of two distinct genes,tracking of the differentiation/activation status of individual cells by regulating the expression of each luciferase with state-dependent promoters and the traffcking of two separate cell populations such as therapeutic cells (e.g., cytotoxic T cells) and diseased cells (e.g., cancer cells). Unlike fluorescence imaging where the cells of interest can be visualized by simply switching a filter，multicomponent BLI requires more complex methods which can pose limitations on the detection sensitivity and accuracy.

One option is to use substrate-resolved luciferases,where the injection of a single substrate is used to activate the respective luciferase. This requires tagging of luciferases with minimal cross-reactivity with the other substrate(s)，also known as orthogonal luciferase-luciferin systems. The dual-BLI proof-ofconcept was first demonstrated in 2O02 by Bhaumik and Gambhir,who subcutaneously implanted C6 rat glioma cells expressing either RLuc or FLuc into single mice,followed by their sequential visualization using CTZ and D-luciferin, respectively.35 Since then, several other groups have used dual-BLI to visualize distinct molecular events or cell populations in vivo,using other luciferase pairs such as FLuc/D-luciferin and GLuc/CTZ,2 and FLuc/D-luciferin and NanoLuc/furimazine.Atriple-BLI system hasalso been demonstrated using FLuc/D-luciferin,GLuc/CTZ，and the codon-optimized luciferase from Vargula hilgendorfii (Vluc) with its substrate vargulin.64 Prescher's group has expanded the toolbox of multicomponent BLI by synthesizing novel orthogonal luciferase-luciferin systems based on FLuc/Dluciferinted $\pi$ extended luciferins enabling red-shifted emission.67 The challenge with these systems, however,remains their low sensitivity in vivo,limiting their detection capability in deep tissues.

The low sensitivity issue could be resolved with the state-ofthe-art bioluminescent reporters described above. The AkaLuc/AkaLumine pair has been used orthogonally with Antares/fluorofurimazine.With intraperitoneally administered FFz or AkaLumine, the expansion or recession of engrafted Antares-expressing MG63.3 osteosarcoma tumor and the circulation and localization of intravenously injected CAR-T cells could be sensitively visualized within the same NSG mice, over a period of $3 0 ~ \mathrm { d a y s } ^ { 3 0 }$ (Figure 4). This pair of luciferase and luciferins for dual-BLI of two cell populations is the most sensitive reported to date.

Another limitation with substrate-resolved luciferases is the need for the signal from the previous luciferase to clear, which can take hours to days.A solution to this issue was recently developed by Rathbun et al.，which relies on substrate unmixing algorithms: substrates are administered in rapid succession, beginning with the dimmest substrate,so that the residual signal from the previous luciferase becomes part of the background noise of the next.8 The set of images can then be used to deconvolute individual substrate signatures.Using this technique，Yao et al.demonstrated for the first time multicomponent imaging of four luciferase-luciferin pairs in vitro.7In 2021, Moroz et al.demonstrated quadruple-BLI in vivo with a slightly different approach,using light wavelengthblocked filters to separate signals. 69 They multiplexed RLuc, CBRLuc, CBGLuc,and a new reporter named membraneanchored Cypridina luciferase (maCLuc),which is paired with the vargulin substrate, to visualize a metastatic tumor model.

With these developments，interpretation of substrateresolved multicomponent BLI can stil be biased by differences in substrate kinetics and biodistribution.Another way to perform multicomponent BLI is through spectrally resolved luciferase pairs,whereby the injection of a single substrate produces distinct emission spectra with multiple luciferases which can be separated using spectral unmixing algorithms. This often employs green- and red-shifted mutant luciferases to minimize overlap in emission spectra.13 Mezzanotte et al. demonstrated invivo dual-BLI of human embryonic kidney cells expressing green CBG99 $( \lambda _ { \mathrm { m a x } } \ = \ 5 3 7 \ \mathrm { \ n m } )$ andred PpyRE8 $\lambda _ { \operatorname* { m a x } } = 6 1 8 ~ \mathrm { n m } ,$ luciferases. They achieved efficient spectral unmixing and sensitive imaging of distinct cell populations injected subcutaneously in mice. However, imaging in deeper tissues can be hampered by greater attenuation of the lower wavelength light which would introduce bias into quantitative comparisons. Recently, Aswendt et al. developed an improved dual-color BLI system with the further mutated $\mathbf { x } 5 \mathbf { r } / \mathbf { x } 5 \mathbf { g }$ pair showing better separated spectra and higher photon flux with the ability to accurately predict_cell population ratios from quantitative unmixing results.71The $\mathbf { x } 5 \mathbf { r } / \mathbf { x } 5 \mathbf { g }$ pair can also be coupled with infraluciferinforred-shifteddual-colorimaging.5In2021, Zambito et al. introduced a further improved NIR dual-BLI system using the substrate $\mathrm { N H } _ { 2 } { \mathrm { - N p L H } } 2$ paired with novel click beetle mutants CBG2( $\lambda _ { \operatorname* { m a x } } = 6 6 0 \mathrm { n m } ,$ and CBR2( $\lambda _ { \operatorname* { m a x } } =$ $7 3 0 \ \mathrm { n m }$ ).57 They showed sensitive deep tissue imaging in a lung model and were able to spectrally resolve and quantify the emissions. Furthermore， the versatility of the system was demonstrated with in vivo dual-BLI of $\mathrm { C B G 2 } / \mathrm { N H _ { 2 } } \mathrm { - N p L H 2 }$ and Akaluc/Akalumine-HCl.

# TECHNOLOGICAL ADVANCEMENTS

In addition to the engineering of luciferase systems at the chemical level，developments in camera technologies and imaging methods have advanced the capabilities of in vivo BLI (Table 2). In brief, these imaging systems consist of a lighttight chamber in which the subject is placed and a cooled charge-coupled device(CCD） camera which collects emited photons. The sensitivity of imaging systems has been greatly improved through the development of intensified CCD (ICCD）and electron multiplying CCD (EMCCD） cameras. This increased sensitivity has subsequently decreased acquisition times from several minutes to millseconds,_enabling video-rate imaging of unanesthetized animals.27,49,72 In addition，development of bioluminescence tomography (BLT） that incorporates CT/MRI information has aided anatomical localization in three dimensions. .73,74 Traditional CCD cameras are blue sensitive, but newer cameras have been optimized for higher quantum efficiency at wavelengths ${ \scriptstyle > 6 0 0 }$ nm，which is especially useful for imaging NIR-emitting luciferases.75 In summary， technological breakthroughs that complement chemical engineering of bioluminescent systems is expected to improve imaging sensitivity and expand future BLI applications.

Table 2. Summary of Key Advancements in Instrumentation and Imaging Methods for in Vivo BLI   

<html><body><table><tr><td> year</td><td>technological advancement</td><td>ref</td></tr><tr><td>2001</td><td>first commercial system designed for BLI of small animals (IVIS,Xenogen Corporation)</td><td>75</td></tr><tr><td>2003</td><td>first bioluminescence tomography (BLT） prototype developed,enabling integration with CTfor quantitative 3D localization of signals</td><td>76</td></tr><tr><td>2006</td><td>development of spectral unmixing algorithms for separating signals from multiple BLI reporters</td><td>77</td></tr><tr><td>2008</td><td>new imaging system developed for video-rate imaging of nonanaesthetized and freely moving mice</td><td>72</td></tr><tr><td>2012</td><td>first time multiple BLI reporter genes were imaged in vivo usingBLT</td><td>78</td></tr><tr><td>2013</td><td>development of a 3D BLI method based on multiple rotating cameras for accelerated data acquisition and improved</td><td>79</td></tr><tr><td>2018</td><td>signal quantification video-rate imaging of Akaluc-expressing striatal neurons in nonanaesthetized marmosets using a MIIS system</td><td>27</td></tr><tr><td>2020</td><td>(Molecular Devices Japan) in vivo BLI in the second near-infrared region (1ooo-1700 nm）achieved using a InGaAs CCD camera (Princeton Instruments, NIRvana-LN)</td><td>80</td></tr></table></body></html>

# CONCLUSIONS

Over the past few decades BLI has emerged as a powerful tool for preclinical visualization of cellular and molecular processes in vivo.The high signal-to-noise ratio,direct relationship of signal to cell viability，and ability to survey processes on a whole-animal scale offers an unparalleled approach to noninvasive imaging.However, the attenuation of light by tissue raises a pressing need for the development of novel red-shifted luciferases and luciferins that can enable sensitive,deep-tissue imaging. Recent advancements in protein engineering and substrate synthesis have pushed the limits of detection,and the expanding toolbox of multicomponent BLI has improved imaging of complex cellular interactions.

The in vivo behavior of BLI systems remains incompletely understood. For substrates, in vivo evaluation should not only characterize bioluminescence output from one location but should also address pharmacodynamics and pharmacokinetics since these substrates act like drugs in vivo.21 An ideal synthetic luciferin should have its organ/tissue biodistribution clearly characterized,1 cause little to no toxicity or behavioral abnormalitytotheinjectedanimalorhaveitssafedosage established,and be free of background bioluminescence caused by auto-oxidation.30,31 For D-luciferin， distribution has been assessed with radioactive tracers，but this has yet to be performed for other substrates.We expect animal testing of advanced luciferase systems to be an area of growing interest as the field of BLI continues to expand.

Another interesting future development is in the combination of the most sensitive BLI reporters with other imaging methods.For example,a multimodal system consisting of a BLI reporter for ease of use and affordability with either an MRI reporter for high 3D resolution or a PET reporter for high 3D sensitivity may overcome limitations inherent to each modality.

In conclusion，we envision further development of luciferase/luciferin systems，along with in vivo testing and incorporation with other imaging reporters, to be a growing and exciting area as we continue to challenge the limits of in vivo imaging.

# AUTHOR INFORMATION

# Corresponding Author

JohnA.Ronald -Robarts Research Institute, The University of Western Ontario, London, Ontario N6A3K7, Canada; Department ofMedical Biophysics, The University of Western Ontario, London, Ontario N6A3K7,Canada; Email: jronald@robarts.ca

Authors Shirley Liu - Robarts Research Institute, The University of Western Ontario, London, Ontario N6A3K7, Canada; Department of Medical Biophysics, The University of Western Ontario, London, Ontario N6A3K7, Canada; $\circledcirc$ orcid.org/ 0000-0003-4777-6917 Yichi Su -Department of Neurobiology， Stanford University, Stanford, California 94305, United States; Department of Bioengineering, Stanford University，Stanford, California 94305,United States; $\circledcirc$ orcid.org/0000-0001-5715-835X Michael Z.Lin -Department of Neurobiology， Stanford University,Stanford, California 94305,United States; Department of ioengineering, Stanford University, Stanford, California 94305,United States; $\circledcirc$ orcid.org/0000-0002- 0492-1961

Complete contact information is available at: https://pubs.acs.org/10.1021/acschembio.1c00549

# Notes

The authors declare no competing financial interest.

# ACKNOWLEDGMENTS

Figures were created with BioRender.com. Funds were provided by NINDS (grant 1R21NS122055).

# KEYWORDS

Bioluminescence imaging (BLI),an imaging technique that allows the visualization of biochemical events and labeled cells via the detection of light emitted by enzyme-catalyzed reactions;Luciferase,an enzyme that produces bioluminescence by oxidizing a compatible substrate；Luciferin，the substrate oxidized by a luciferase to produce bioluminescence; Near-infrared luciferins (NIRLucs)，a class of luciferins emitting light in the near-infrared range $( \sim 6 5 0 - 9 0 0 ~ \mathrm { \ n m } )$ ， enabling higher light penetration at deep tissues；Bioluminescence resonance energy transfer (BRET), an energy transfer event occurring between an excited luciferase-bound substrate and an acceptor fluorescent protein； the emited wavelength of a BRET system is higher than thatof the donor luciferase;Dual-BLI, BLI of a pair of orthogonal luciferases and luciferins，allowing the tracking of independent biochemical or cellular events; Substrate-resolved luciferases,a pair of luciferases that are independently activated following administration of the appropriate substrate； Spectrally resolved luciferases,a pair of luciferases that utilize the same substrate but produce distinct emission spectra； their activity is separated using spectral unmixing algorithms.

# REFERENCES

(1）Kang, J. H.； Chung, J. K. Molecular-genetic imaging based on reporter gene expression. J. Nucl. Med. 2008,49 (Suppl2)，164S179S.   
(2) Badr, C.E.; Tannous, B. A. Bioluminescence imaging: progress and applications. Trends Biotechnol. 2011,29,624-633.   
(3)Edinger,M.; Cao,Y.A.; Hornig, Y.S.; Jenkins,D.E.; Verneris, M.R; Bachmann, M. H.; Negrin, R S.; Contag, C. H. Advancing animal modelsofneoplasiathrough invivobioluminescenceimaging Eur. J. Cancer 2002,38,2128-2136.   
(4)Mandl,S.；Schimmelpfennig,C.；Edinger,M.；Negrin,RS.; Contag， C. H. Understanding immune celltrafficking patterns via in vivo bioluminescence imaging. J. Cell Biochem.2002,87, 239-248. (5)Paroo,Z.; Bollnger,R.A; Braasch,D.A.;Richer,E.; Corey,D. R; Antich,P.P.; Mason, R.P.Validating bioluminescenceimaging as a high-throughput, quantitative modality for assessing tumor burden. Mol. Imaging2004,3,117-124.   
(6) Dothager,R. S.; Flentie,K.; Moss,B.; Pan,M.H.; Kesarwala,A.; Piwnica-Worms， D. Advances in bioluminescence imaging of live animal models. Curr. Opin. Biotechnol. 2009,20, 45-53.   
(7） Vieira,J.;Pinto da Silva,L.;Esteves da Silva,J.C.Advances in the knowledge oflight emision by firefly luciferin and oxyluciferin.J. Photochem.Photobiol., B 2012,117,33-39.   
(8) Zhao,H.； Doyle, T. C.；Coquoz, O.； Kalish,F.； Rice,B. W.; Contag， C.H. Emission spectra of bioluminescent reporters and interaction with mammalian tissue determine the sensitivity of detection in vivo.J.Biomed. Opt. 2005,10,041210.   
(9）Fleiss，A.； Sarkisyan，K.S.A brief review of bioluminescent systems (2019). Cur Genet.2019, 65,877-882.   
(10)Kobayashi, H.; Ogawa,M.; Alford,R; Choyke,P.L.; Urano, Y. New strategies for fluorescent probe design in medical diagnostic imaging. Chem.Rev.2010,110,2620-2640.   
(11）Berger，F.；Paulmurugan，R.；Bhaumik，S.；Gambhir，S.S. Uptake kinetics and biodistribution of14C-D-luciferin-a radiolabeled substrate for the firefly luciferase catalyzed bioluminescence reaction: impact on bioluminescence based reporter gene imaging. Eur. J. Nucl. Med.Mol. Imaging 2008,35,2275-2285.   
(12）Yeh，H. W.；Ai,H.W. Development and Applications of Bioluminescent and Chemiluminescent Reporters and Biosensors. Annu. Rev.Anal. Chem. 2019,12,129-150.   
(13）Branchini, B.R.； Southworth, T.L.; Khattak,N.F.; Michelini, E.；Roda,A. Red- and green-emitting firefly luciferase mutants for bioluminescent reporter applications.Anal. Biochem. 2005,345,140- 148.   
(14）Wang, Y.； Akiyama,H.； Terakado, $\mathrm { K . } \mathrm { \Omega }$ Nakatsu, T. Impact of site-directed mutant luciferase on quantitative green and orange/red emisson intensities in firefly bioluminescence.Sci. Rep.2013,3,2490. (15）Loening, A. M.； Fenn, T.D.； Wu, A. M.； Gambhir, S. S. Consensus guided mutagenesis of Renilla luciferase yields enhanced stabilityand light output.Protein Eng.,Des.Sel.2006,19,391-400. (16)Loening, A.M.; Wu, A. M.; Gambhir,S. S.Red-shifted Renilla reniformis luciferase variants for imaging in living subjects. Nat. Methods 2007,4,641-643.   
(17）Cheng,Y. Y.；Liu， Y. J. Theoretical Development of NearInfrared Bioluminescent Systems. Chem. - Eur. J. 2018, 24, 9340- 9352.   
(18）Pirrung,M.C.； Biswas,G.； De Howitt,N.; Liao,J. Synthesis and bioluminescence of difluoroluciferin.Bioorg.Med. Chem. Lett. 2014. 24. 4881-4883. luciferase.J.Am. Chem. Soc.2010,132,13586-13587.   
(20） Chandran, S.S.；Williams,S.A.； Denmeade,S.R.Extendedrelease PEG-luciferin allowsfor long-term imaging of firefly luciferase activity in vivo.Luminescence 20o9,24,35-38.   
(21)Mofford,D.M.; Miller, S.C.Luciferins behave like drugs.ACS Chem.Neurosci. 2015,6,1273-1275.   
(22）Shinde,R.; Perkins, J.; Contag, C.H. Luciferin derivatives for enhanced in vitro and in vivo bioluminescence assays. Biochemistry 2006,45, 11103-11112.   
(23）Evans,M. S.； Chaurette,J.P.；Adams, S.T.； Reddy,G.R; Paley，M.A.；Aronin,N.； Prescher, J.A.；Miller, S.C.A synthetic luciferin improves bioluminescence imaging in live mice. Nat. Methods 2014,11, 393-395.   
(24）Mofford,D.M.； Reddy,G.R.； Miller,S.C.Aminoluciferins extend firefly luciferase bioluminescence into the near-infrared and can be preferred substrates over D-luciferin.J.Am. Chem. Soc.2014, 136,13277-13282.   
(25)Adams,S.T.,Jr.; Mofford,D.M.；Reddy,G.S.; Miller, S.C. Firefly Luciferase Mutants Allow Substrate-Selective Bioluminescence Imaging in the Mouse Brain.Angew.Chem., Int.Ed.2016,55,4943- 4946.   
(26）Kuchimaru，T.；Iwano，S.；Kiyama，M.；Mitsumata，S.; Kadonosono,T.；Niwa,H.；Maki, S.； Kizaka-Kondoh, S.A luciferin analogue generating near-infrared bioluminescence achieves highly sensitive deep-tissue imaging. Nat. Commun. 2016,7,11856.   
(27) Iwano, S.; Sugiyama, M.; Hama,H.;Watakabe,A.; Hasegawa, N.; KuchimaruT;Tanaka,K.Z.; Takahashi,.; hida,Y;HataJ; Shimozono，S.；Namiki，K.；Fukano，T.；Kiyama，M.；Okano，H.; Kizaka-Kondoh,S.; McHugh,T.J.; Yamamori,T.; Hioki,H.; Maki,S.; Miyawaki， A. Single-cell bioluminescence imaging of deep tissue in freely moving animals. Science 2018,359, 935-939.   
(28) Bozec, D.； Sattiraju,A.; Bouras,A.; Jesu Raj,J. G.; Rivera,D.; Huang, Y.; JunqueiraAlves,C.; Tejero,R; Tsankova,N.M.; ZouH.; Hadjipanayis，C.；Friedel，R.H.Akaluc bioluminescenceoffers superior sensitivity to track in vivo glioma expansion. Neurooncol Adv.2020,2 (2)， No. vda134.   
(29）Amadeo,F.，Plagge，A.， Chacko，A.，Wilm，B.，Hanson,V., Liptrott，N.，Murray,P.，Taylor，A.(2021） Firefly luciferase offers superior performance to AkaLuc for tracking the fate of administered cell therapies,Eur.J. Nucl. Med.Mol. Imaging,DOI: 10.1007/s00259- 021-05439-4.   
(30) Su, Y.; Walker,J. R; Park, Y.; Smith, T.P.; Liu, L. X.; Hall,M. P.；Labanieh,L.；Hurst,R;Wang,D.C.；Encell L.P.；Kim，N.; Zhang,F.; Kay,M.A; Casey,K.M.； Majzner,R.G.; Cochran,J.R; Mackall,C.L.; Kirkland, T.A.; Lin,M.Z.Novel NanoLuc substrates enable bright two-population bioluminescence imaging in animals. Nat. Methods 2020, 17,852-860.   
(31）Nakayama, J； Saito,R.；Hayashi,Y.； Kitada,N.；Tamaki，S.; Han,Y.; Semba,K;Maki, S.A.High Sensitivity InVivoImagingof Cancer Metastasis Using a Near-Infrared Luciferin Analogue seMpai. Int. J. Mol. Sci. 2020,21,7896.   
(32） Ikeda, Y.； Nomoto,T.; Hiruta, Y.; Nishiyama, N.; Citterio,D. Ring-Fused Firefly Luciferins:Expanded Palete of Near-Infrared Emiting Bioluminescent Substrates.Anal. Chem.2020,92,4235 4243.   
(33) Jathoul,A.P.; Grounds,H.; Anderson,J C.; Pule,M.A.A dualcolor far-red to near-infraredfirefly luciferinanalogue designed for multiparametric bioluminescence imaging. Angew. Chem., Int. Ed. 2014,53, 13059-13063.   
(34) Hall,M. P.; Woodroofe,C. C.; Wood,M. G.; Que,L; Van't Root,M.; Ridwan,Y.; Shi, C.; Kirkland, T.A.;Encell,L.P.; Wood,K. V.; Lowik, C.; Mezzanotte,L. Click beetle luciferase mutant and near infrared naphthyl-luciferins for improved bioluminescence imaging. Nat.Commun.2018,9,132.   
(35）Bhaumik,S.；Gambhir，S.S.Optical imaging of Renilla luciferasereporter gene expression in living mice. Proc. Natl. Acad. Sci. U. S.A. 2002.99.377-382. (36) Zhao,H.; Doyle,T.C.; Wong, R J.; Cao,Y.; Stevenson, D.K.;   
Piwnica-Worms, D.; Contag, C.H. Characterization of coelenterazine   
analogs for measurements of Renilla luciferase activity in live cels and   
living animals. Mol. Imaging 2004,3,43-54. (37) Jiang,T.；Du,L.；Li,M.Lighting upbioluminescence with   
coelenterazine: strategies and applications.Photochem. Photobiol. Sci.   
2016,15, 466-480. (38)Shakhmin,A.; Hal, M.P.; Machleidt, T.; Walker,J. R.; Wood,   
K.V.；Kirkland，T.A. Coelenterazine analogues emit red-shifted   
bioluminescence with NanoLuc. Org. Biomol. Chem. 2017,15,859-   
8567. (39）Otto-Duessel，M.；Khankaldyyan，V.；Gonzalez-Gomez，I;   
Jensen，M.C.；Laug,W.E.；Rosol,M.In vivo testingof Renilla   
luciferase substrate analogs in an orthotopic murine model of human   
glioblastoma. Mol. Imaging 2006, 5, 57-64. (40) Nishihara,R.; Citterio,D.; Suzuki, K. Synthetic Bioluminescent   
Coelenterazine Derivatives.Methods Mol.Biol.2016,1461,19-31. (41) Jiang, T.; Yang, X.; Zhou, Y.; Yampolsky,L.; Du,L.; Li,M.New   
bioluminescent coelenterazine derivatives with various C-6 sub  
stitutions. Org. Biomol. Chem. 2017,15,7008-7018. (42) Coutant, E.P.; Goyard, S.; Hervin, V.;Gagnot, G.; Baatallah,   
R.; Jacob,Y.; Rose,T.; Janin, Y.L.Gram-scale synthesis of luciferins   
derived from coelenterazine and original insights into their bio  
luminescence properties.Org. Biomol. Chem. 20i9,17,3709-3713. (43)Li, J.; Wang, X.; Dong, G.; Yan, C.; Cui, Y.; Zhang,Z.; Du,L.;   
Li,M.Novel furimazine derivatives for nanoluciferase biolumines  
cence with various C-6 and C-8 substituents. Org. Biomol. Chem.   
2021,19, 7930-7936. (44)Hall,M.P.; Unch,J.; Binkowski, B.F.; Valley,M.P.; Butler,B.   
L.; Wood,M. G.; Otto,P.; Zimmerman, K.; Vidugiris, G.; Machleidt,   
T；Robers，M.B.； Benink,H.A；Eggers,C. T.； Slater，M.R;   
Meisenheimer,P.L.; Klaubert,D.H.; Fan,F.; Encell,L.P.;Wood,K.   
V. Engineered luciferase reporter from a deep sea shrimp utilizing a   
novel imidazopyrazinone substrate.ACS Chem. Biol. 2012,7,1848-   
1857. (45)Yeh,H. W.; Karmach,O.; Ji,A.; Carter,D.; Martins-Green, M.   
M；AiH.W.Red-shiftedluciferase-luciferin pairsforenanced   
bioluminescence imaging.Nat. Methods 2017,14, 971-974. (46) Yeh,H. W.; Xiong, Y.; Wu, T.; Chen, M.; Ji, A.; Li, X.; Ai, H.   
W. ATP-Independent Bioluminescent Reporter Variants To Improve   
in Vivo Imaging.ACS Chem.Biol.2019,14,959-965. (47)Dragulescu-Andrasi, A.; Chan, C. T.; De, A.； Massoud, T.F.;   
Gambhir, S.S. Bioluminescence resonance energy transfer (BRET)   
imaging of protein-protein interactions within deep tissues of living   
subjects.Proc.Natl. Acad.Sci.U. S.A.2011,108,12060-12065. (48）Hoshino,H.； Nakajima,Y.; Ohmiya,Y.Luciferase-YFP fusion   
tag with enhanced emission for single-celluminescence imaging. Nat.   
Methods 2007,4, 637-639. (49)Saito,K.; Chang, Y.F.; Horikawa,K.; Hatsugai,N.; Higuchi, Y.;   
Hashida，M.；Yoshida，Y.；Matsuda，T.；Arai，Y.；Nagai，T.   
Luminescent proteins for high-speed single-cell and whole-body   
imaging. Nat. Commun. 2012, 3,1262. (50)Rumyantsev, K.A.； Turoverov,K.K.; Verkhusha, V.V. Near  
infraredbioluieentpoteisfortolrulioaling   
Sci. Rep. 2016,6, 36588. (S1) Suzuki, K.；Kimura,T.； Shinoda,H.； Bai, G.； Daniels,M.J.;   
AraiY.；Nakano，M.；NagaiT.Fivecolourvariantsof bright   
luminescentproteinforrea-timemulticolourbioimaging.Nat.   
Commun. 2016, 7, 13718. (52) Schaub,F.X.; Reza, M. S.; Flaveny,C.A.; Li, W.; Musicant, A.   
M.; Hoxha, S. Guo, M.; Cleveland,J. L.Amelio,A.L. Fluorophore  
NanoLuc BRET Reporters Enable Sensitive In Vivo Optical Imaging   
and Flow Cytometry for Monitoring Tumorigenesis. Cancer Res.   
2015,75, 5023-5033. (53) Chu, J.; Oh, Y.； Sens,A.；Ataie,N.; Dana,H.；Macklin,J. J;   
Laviv,T.; Welf,E.S.; DeanK..; Zhang,F.; Kim,B.B.TangC.T   
Hu，M.； Baird,M.A.； Davidson,M.W.； Kay，M.A.； Fiolka，R;   
Yasuda,R; Kim, D.S.; Ng,H.L.; Lin,M. Z. Abright cyan-excitable   
orange fluorescent protein facilitates dual-emission microsconv and enhances bioluminescence imaging in vivo.Nat. Biotechnol. 2016,34, 760-767.   
(54) Lee,K.H.; Byun, S.S.; Paik,J. Y.; Lee,S.Y.; Song, S.H.; Choe, Y. S.；Kim,B.T. Cell uptake and tissue distribution of radioiodine labelled D-luciferin: implications for luciferase based geneimaging. Nucl.Med. Commun. 2003,24,1003-1009.   
(55) Wu, W.; Su,J.; Tang,C.; Bai,H; Ma,Z.; Zhang,T.; Yuan,Z.; Li, Z.; Zhou, W.; Zhang,H.; Liu, Z.; Wang, Y.; Zhou,Y.; Du,L.; Gu, L;LiM.cyc:AnEAofenDeieep Bioluminescence Imaging. Anal. Chem. 2017, 89, 4808-4816.   
(56) Stowe,C.L.; Burley,T.A; Allan,H.; Vinci, M.; Kramer-Marek, G.; Ciobota, D.M.; Parkinson, G.N.; Southworth, T.L.; Agliardi, G.; Hotblack，A.；Lythgoe，M.F.；Branchini，B.R.；Kalber，T.L.; Anderson， J. C.； Pule，M. A.Near-infrared dual bioluminescence imaging in mouse models of cancer using infraluciferin,eLife 2019, 8, DOI: 10.7554/eLife.45801   
(57) Zambito, G.; Hall,M.P.; Wood,M. G.; Gaspar,N.; Ridwan,Y.; Stellari，F.F.；Shi,C.；Kirkland，T.A.；Encell,L.P.；Lowik,C.; Mezzanotte, L. Red-shifted click beetle luciferase mutant expands the multicolor bioluminescent palette for deep tisse imaging. iScience 2021,24,101986.   
(58)Lorenz,W.W.; Cormier,M.J.; O'Kane,D.J.; Hua,D.; Escher, A A; Szalay，AAExpressoofteRenillfisg in mammalian cels.J. Biolumin.Chemilumin.1996,11,31-37. (59)Gaspar，N.；Walker,J.R；Zambito,G.；Marella-Panth，K.; Lowik,C.；Kirkland,T.A.； Mezzanotte,L. Evaluation of NanoLuc substrates for bioluminescence imaging of transferred cels in mice. J. Photochem.Photobiol., B 2021,216,112128.   
(60） Tannous, B.A.； Kim, D.E.; Fernandez, J.L.; Weissleder,R; Breakefield,X.O.Codon-optimized Gaussia luciferase cDNA for mammalian gene expression in culture and in vivo. Mol. Ther. 2005, 11, 435-443.   
(61）Kim, S.B.； Suzuki, H.； Sato,M.； Tao,H. Superluminescent variants of marine luciferases for bioassays. Anal. Chem. 2011，83, 8732-8740.   
(62) Serganova,I.; Moroz,E.; Vider,J.; Gogiberidze,G.;Moroz, M.; Pilarsety,N;obovn;;leH.J Gelovani,J;Basberg,RMultimodalityiagingofFbetaialing in breast cancer metastases.FASEB J. 2009,23, 2662-2672.   
(63) Stacer,A.C.; Nyati,S.; Moudgil,P.; Iyengar,R;Luker,K.E.; Rehemtull,A.； Luker,G.D. NanoLuc reporter for dual luciferase imaging in livinganimals.Mol.Imaging 2013,12,1-13.   
(64)Maguire, C.A.; Bovenberg, M. S.; Crommentuijn,M.H.; Niers, J. M; Kerami,M.; Teng,J.;Sena-Esteves,M.; Badr,C.E.; Tannous,B. A.Triple bioluminescence imaging for in vivo monitoring of cellular processes.Mol. Ther.-ucleic Acids13,2,No.e99.   
(65）Willams，S.J.；Hwang,C.S.；Prescher, J.A.Orthogonal Bioluminescent Probes from Disubstituted Luciferins.Biochemistry 2021, 60, 563-572.   
(66) Brennan,C.K.； Ornelas,M. Y.； Yao,Z. W.； Prescher, J. A. Multicomponent Bioluminescence Imaging with Naphthylamino Luciferins. ChemBioChem 2021,22,2650.   
(67) Yao,Z.; Zhang, B.S.; Steinhardt,R.C.; Mills,J.H.; Prescher,J. A.Multicomponent Bioluminescence Imaging with a $\pi$ Extended Luciferin. J.Am. Chem. Soc. 2020,142,14080-14089.   
（68）Rathbun，C.M.；Ionkina，A.A.；Yao，Z.； Jones，K.A.; Porterfield，W.B.；Prescher，J.A.Rapid Multicomponent Bioluminescence Imaging via Substrate Unmixing. ACS Chem. Biol. 2021, 16,682-690.   
(69）Moroz,M.A.； Zurita, J.；Moroz,A.； Nikolov,E.； Likar,Y.; Dobrenkov，K.；Lee,J.； Shenker，L.；Blasberg，R；Serganova,I; Ponomarev, V. Introducing a new reporter gene, membrane-anchored Cypridina luciferase,for multiplex"bioluminescence imaging. Mol. Ther Oncolytics 2021, 21,15-22.   
(70）Mezzanotte,L.； Que,I.； Kaijzel, E.；Branchini,B.；Roda,A.; Lowik, C.Sensitive dualcolorinvivobioluminescence imaging using a new red codon optimized firefly luciferase and a green click betle luciferace PInS One 2011 6 Nn e19277

(71）Aswendt,M.；Vogel, S.；Schafer,C.； Jathoul,A.；Pule，M.; Hoehn, M. Quantitative in vivo dual-color bioluminescence imaging in the mouse brain.Neurophotonics 2019,6,025006. (72)Roncali,E.; Savinaud,M.; Levrey,O.;Rogers,K.L.; Maitrejean, S.; Tavitian, B.New device for real-time bioluminescence imaging in moving rodents. J. Biomed. Opt. 2008,13,054035. (73) Wang G.; Cong, W.; Shen, H.; Qian, X.; Henry, M.; Wang, Y. Overview of bioluminescence tomography-a new molecular imaging modality.Front.Biosci.,Landmark Ed.2008,13,1281-1293. (74）Klose,A.D.； Beattie,B. J. Bioluminescence tomography with CT/MRI co-registration. Annu. Int. Conf IEEE Eng. Med. Biol. Soc. 2009,2009,6327-6330. (75） Rice, B.W.; Cable,M. D.; Nelson,M. B.In vivo imaging of light-emitting probes.J. Biomed. Opt. 2001,6,432-440. (76) Wang, G.; Hoffman,E.; McLennan, G.Development of the first bioluminescent tomography system. Radiology Suppl. (Proceedings of the RSNA)；Radiological Society of North America,2003;p 229. (77）Gammon, S.T.； Leevy，W. M.； Gross,S.；Gokel, G.W.; Piwnica-Worms,D. Spectral unmixing of multicolored bioluminescence emitted from heterogeneous biological sources.Anal. Chem. 2006,78,1520-1527. (78) Cronin,M.; Akin, A.R.; Collins, S.A.; Meganck,J.; Kim,J. B.; Baban,C.K.; Joyce, S.A.; van Dam, G.M.; Zhang,N.; van Sinderen, D.； O'Sullivan, G.C.； Kasahara，N.； Gahan,C.G.； Francis，K.P.; Tangney,M.High resolution in vivo bioluminescent imaging for the study of bacterial tumour targeting.PLoS One 2012,7,No.e30940. (79）Lewis,M.A.；Richer,E.； Slavine,N.V.；Kodibagkar,V.D.; Soesbe, T.C.; Antich,P.P.; Mason, R.P.A Multi-Camera System for Bioluminescence Tomography in Preclinical Oncology Research. Diagnostics 2013,3,325-343. (80) Lu,L.; Li,B.; Ding, S.; Fan, Y.; Wang, S.； Sun,C.; Zhao,M.; Zhao,C.X.； Zhang, F.NIR-II bioluminescence for in vivo high contrast imaging and in situ ATP-mediated metastases tracing. Nat. Commun. 2020, 11, 4192.